%Cette routine permet d'automatiser la cration de votre fichier contenant
%vos hauteurs d'eau si vous avez tlcharg vos donnes sur data.shom.fr
%Placez cette routine dans votre dossier "...\CoastSnap\Tide Data"
%
%Created by Nicolas Giraud - Godunes 
%12/05/2023
%

% Fichier txt contenant les hauteurs d'eau tlcharg sur data.shom.fr 
filename = '2_2024.txt'; % Dzippez votre tlchargement et placez le fichier txt '2_2024.txt' dans le mme dossier que cette prsente routine.

% Vrifier si le fichier TIDE_Geodunes.mat existe
tideFile = 'TIDE_Geodunes.mat'; % Remplacez par le nom de votre fichier si ncessaire

if isfile(tideFile)
    load(tideFile, 'tide'); % Charger les donnes existantes
else
    fprintf('Le fichier "%s" n''existe pas.\n', tideFile);
    createFile = input('Voulez-vous crer un fichier vide pour dmarrer ? (y/n) : ', 's');
    if strcmpi(createFile, 'y')
        tide.time = [];
        tide.level = [];
        tide.timezone = 'UTC'; % Par dfaut
        tide.datum = 'SHOM';   % Par dfaut
        save(tideFile, 'tide');
        disp(['Fichier cr : ', tideFile]);
    else
        error('Processus arrt : le fichier de donnes de mare est requis.');
    end
end

% Lire le fichier texte brut
fileID = fopen(filename, 'r');
if fileID == -1
    error('Impossible d''ouvrir le fichier %s. Vrifiez son emplacement.', filename);
end
rawData = textscan(fileID, '%s %f %*d', 'Delimiter', ';', 'CommentStyle', '#');
fclose(fileID);

% Convertir la date/heure en format MATLAB
dates = datenum(rawData{1}, 'dd/mm/yyyy HH:MM:SS');
levels = rawData{2};

% Afficher le nombre de donnes brutes lues
fprintf('Nombre de donnes brutes lues : %d\n', length(dates));

% Supprimer les doublons dans les nouvelles donnes (en fonction de date/heure uniquement)
[uniqueDates, uniqueIdx] = unique(dates);
uniqueLevels = levels(uniqueIdx);

% Afficher le nombre de donnes aprs suppression des doublons
fprintf('Nombre de donnes aprs suppression des doublons : %d\n', length(uniqueDates));

% Trouver les nouvelles donnes qui ne sont pas dj prsentes
isNewData = ~ismember(uniqueDates, tide.time);

% Afficher le nombre de nouvelles donnes
fprintf('Nombre de nouvelles donnes : %d\n', sum(isNewData));

% Extraire les nouvelles donnes
newTimes = uniqueDates(isNewData);
newLevels = uniqueLevels(isNewData);

% Combiner les anciennes et les nouvelles donnes
allTimes = [tide.time; newTimes];
allLevels = [tide.level; newLevels];

% Supprimer les doublons dans toutes les donnes combines (en fonction de date/heure uniquement)
[uniqueTimes, uniqueIdx] = unique(allTimes);
uniqueLevels = allLevels(uniqueIdx);

% Mettre  jour la structure tide
tide.time = uniqueTimes;
tide.level = uniqueLevels;

% Enregistrer les donnes combines
save(tideFile, 'tide');

disp('Mise  jour des donnes effectue avec succs!');

% Afficher le nombre total de donnes aprs mise  jour
fprintf('Nombre total de donnes aprs mise  jour : %d\n', length(tide.time));