% Adaptations CoastSnapFR:
% - Modified by Nicolas Giraud - https://www.geodunes.fr/ (July 2022)
%   - Extracts and compares the time zone of the image and the site.
%   - Calculates local time from epoch time and the identified time offset.
%   - Translation of the tag EN -> FR
%
% ---------------------------------------------------------

%Insert site-specific data here
site = 'zuydcooteouest'
photoshoptemp_dir = 'C:\Users\nicol\Desktop\_CoastSnap\Images\zuydcooteouest\Registered\2024\PS'; %Name of directory where you have saved your registered images from photoshop


%Now do processing
files = dir([photoshoptemp_dir filesep '*.jpg']);
siteDB = CSPreadSiteDB(site);
for i = 1:length(files)
    i
    fname = files(i).name(7:end-4) %Assumes that your exported files have the default 6-char identifyer from Photoshop
    %fname = files(i).name;
    %out = CSreadImageData(files(i).name)
    
    out = CSPparseFilename(fname)
    I = imread(fullfile(photoshoptemp_dir,files(i).name));
    width = 20;
ax_height = width*size(I,1)/size(I,2);
geomplot(1,1,1,1,width,ax_height,[0 0],[0 0],[0 0])
image(I)
axis off
XL = xlim;
YL = ylim;

% Nicolas Giraud - https://www.geodunes.fr/ (July 2022) : compare et importe le bon fuseau horaire
%(TZname) et son dcalage par rapport  l'UTC(TZoffset)
site = CSPreadSiteDB(out.site); %NG
TZname = out.timezone %NG

if strcmp(TZname,site.timezone.name); %NG
TZName = site.timezone.name; %NG
TZoffset = site.timezone.gmt_offset; %NG
else strcmp(TZname,site.timezone.alternative.name); %NG
TZName = site.timezone.alternative.name; %NG
TZoffset = site.timezone.alternative.gmt_offset; %NG
end %NG

matlablocal = CSPepoch2LocalMatlab(str2num(out.epochtime),TZoffset); %NG

tidelevel = CSPgetTideLevel(str2num(out.epochtime),out.site);
user = strrep(out.user,'_','');
txt = ['Date: ' datestr(matlablocal,'dd/mm/yyyy') ' Heure: ' datestr(matlablocal,'HH:MM') ' Observateur: ' user ', Hauteur d''eau : ' num2str(tidelevel,'%0.2f') 'm ZH']; %NG
h=text(XL(1)+0.02*diff(XL),YL(1)+0.02*diff(YL),txt,'color',0.2*[1 1 1]);
h.HorizontalAlignment = 'left';
h.FontSize = 12;
print(fullfile(photoshoptemp_dir,strrep(fname,'.jpg','_registered.jpg')),'-r400','-djpeg')
close all
end